@extends('layouts.app')

@section('content')
<div class="container-fluid col-md-10 py-4">
    <div class="card">
        <div class="card-header bg-primary text-white ">
            <h3 class="card-title mb-0">Edit Produk</h3>
        </div>

        <div class="card-body">

        <form action="{{ route('produks.update', $produk->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="mb-3">
                <label for="name" class="form-label">Nama Produk</label>
                <input type="text" name="name" class="form-control" value="{{ old('name', $produk->name) }}" required>
            </div>

            <div class="mb-3">
                <label for="explanation" class="form-label">Deskripsi</label>
                <textarea name="explanation" class="form-control" rows="4" required>{{ old('explanation', $produk->explanation) }}</textarea>
            </div>

            <div class="mb-3">
                <label for="image" class="form-label">Gambar Produk</label><br>
                @if($produk->image)
                    <img src="{{asset('storage/' . $produk->image) }}" id="preview" class="mb-2 rounded" style="max-height: 200px;"><br>
                @endif
                <input type="file" name="image" class="form-control" accept="image/*">
                <small class="text-muted">Kosongkan jika tidak ingin mengganti gambar</small>
            </div>

            <div class="mb-3">
                <label for="Price" class="form-label">Harga</label>
                <input type="number" name="price" class="form-control" value="{{ old('price', $produk->price) }}" required>
            </div>

            <button type="submit" class="btn btn-primary">Update</button>
            <a href="{{ route('produks.index') }}" class="btn btn-secondary">Kembali</a>
        </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.querySelector('input[name="image"]').addEventListener('change', function(e) {
    const [file] = e.target.files;
    if (file) {
        const preview = document.getElementById('preview');
        preview.src = URL.createObjectURL(file);
        preview.style.display = 'block';
    }
});
</script>
@endpush
