@extends('layouts.app')

@section('content')
<div class="container-fluid col-md-10 py-4">
    
    @if ($errors->any())
    <div class="alert alert-danger">
        <strong>Oops! Ada error:</strong>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="card">
        <div class="card-header bg-primary text-white">
            <h3 class="card-title">Tambah Produk</h3>
        </div>
        <div class="card-body">
            <form action="{{ route('produks.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Produk</label>
                    <input type="text" name="name" class="form-control" value="{{ old('name') }}" required autofocus>
                </div>

                <div class="mb-3">
                    <label for="explanation" class="form-label">Deskripsi</label>
                    <textarea name="explanation" class="form-control" rows="4" required>{{ old('explanation') }}</textarea>
                </div>

                <div class="mb-3">
                    <label for="image" class="form-label">Gambar</label>
                    <input type="file" name="image" class="form-control" accept="image/*">
                    <img id="preview" class="mt-3 rounded" style="display:none; max-height: 200px;">
                </div>

                <div class="mb-3">
                    <label for="price" class="form-label">Harga</label>
                    <input type="number" name="price" class="form-control" value="{{ old('price') }}" required>
                </div>

                <button type="submit" class="btn btn-primary">Simpan</button>
                <a href="{{ route('produks.index') }}" class="btn btn-secondary">Kembali</a>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.querySelector('input[name="image"]').addEventListener('change', function(e) {
    const [file] = e.target.files;
    if (file) {
        const preview = document.getElementById('preview');
        preview.src = URL.createObjectURL(file);
        preview.style.display = 'block';
    }
});
</script>
@endpush
