@extends('layouts.app')

@section('content')
<div class="container">
    <h3 class="mb-4">Riwayat Pengiriman Stok</h3>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if(auth()->user()->akses === 'admin')
        <a href="{{ route('pengiriman-stok.create') }}" class="btn btn-primary mb-3">+ Pengiriman Baru</a>
    @endif

    <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle text-nowrap">
            <thead class="table-light">
                <tr>
                    <th>No</th>
                    <th>Produk</th>
                    <th>Mitra</th>
                    <th>Jumlah</th>
                    <th>Harga Satuan</th>
                    <th>Total Harga</th>
                    <th>Tanggal Kirim</th>
                    <th>Tanggal Terima</th>
                    <th>Status</th>
                    @if(in_array(auth()->user()->akses, ['sales', 'admin']))
                        <th>Aksi</th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach($pengirimanStoks as $item)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $item->produk->name ?? '-' }}</td>
                        <td>{{ $item->mitra->name ?? '-' }}</td>
                        <td>{{ $item->jumlah }}</td>
                        <td>Rp{{ number_format($item->harga_satuan, 0, ',', '.') }}</td>
                        <td>Rp{{ number_format($item->total_harga, 0, ',', '.') }}</td>
                        <td>{{ \Carbon\Carbon::parse($item->tanggal_kirim)->format('d-m-Y') }}</td>
                        <td>
                            {{ $item->tanggal_terima 
                                ? \Carbon\Carbon::parse($item->tanggal_terima)->format('d-m-Y H:i') 
                                : '-' }}
                        </td>
                        <td>
                            <span class="badge bg-{{ $item->status === 'pending' ? 'warning' : 'success' }}">
                                {{ ucfirst($item->status) }}
                            </span>
                        </td>
                        @if(in_array(auth()->user()->akses, ['sales', 'admin']))
                        <td>
                            @if($item->status === 'pending')
                            <form action="{{ route('pengiriman-stok.konfirmasi', $item->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <button class="btn btn-sm btn-success" 
                                        onclick="return confirm('Yakin konfirmasi terima?')">
                                    Konfirmasi
                                </button>
                            </form>
                            @else
                                <span class="text-muted">Sudah Diterima</span>
                            @endif
                        </td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
