@extends('layouts.app')

@section('content')
<div class="container">
    <h3 class="mb-4">Form Pengiriman Stok</h3>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('pengiriman-stok.store') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label for="produk_id" class="form-label">Produk</label>
            <select name="produk_id" class="form-select" required>
                <option value="">-- Pilih Produk --</option>
                @foreach($produks as $produk)
                    <option value="{{ $produk->id }}" {{ old('produk_id') == $produk->id ? 'selected' : '' }}>
                        {{ $produk->name }} - Rp{{ number_format($produk->price) }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="mitra_id" class="form-label">Mitra</label>
            <select name="mitra_id" class="form-select" required>
                <option value="">-- Pilih Mitra --</option>
                @foreach($mitras as $mitra)
                    <option value="{{ $mitra->id }}" {{ old('mitra_id') == $mitra->id ? 'selected' : '' }}>
                        {{ $mitra->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="jumlah" class="form-label">Jumlah</label>
            <input type="number" name="jumlah" class="form-control" min="1" required value="{{ old('jumlah') }}">
        </div>

        <div class="mb-3">
            <label for="tanggal_kirim" class="form-label">Tanggal Kirim</label>
            <input type="date" name="tanggal_kirim" class="form-control" required value="{{ old('tanggal_kirim') }}">
        </div>
        
        {{-- <div class="mb-3">
            <label for="terjual" class="form-label">Terjual</label>
            <input type="number" name="terjual" class="form-control" min="0" value="{{ old('terjual', 0) }}" required>
        </div>
        
        <div class="mb-3">
            <label for="return" class="form-label">Return</label>
            <input type="number" name="return" class="form-control" min="0" value="{{ old('return', 0) }}" required>
        </div>
        
        <div class="mb-3">
            <label for="sisa" class="form-label">Sisa</label>
            <input type="number" name="sisa" class="form-control" min="0" value="{{ old('sisa', 0) }}" required>
        </div> --}}

        {{-- <div class="mb-3">
            <label for="harga_satuan" class="form-label">Harga Satuan</label>
            <input type="number"  name="harga_satuan" id="harga_satuan" class="form-control" required>
        </div>
        
         --}}

        <button type="submit" class="btn btn-primary">Kirim</button>
        <a href="{{ route('pengiriman-stok.index') }}" class="btn btn-secondary">Batal</a>
    </form>
</div>
@endsection
