@extends('layouts.app')

@section('content')
<div class="container py-3">
    <h1 class="mb-4">Daftar Mitra Anda</h1>

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover align-middle text-center">
            <thead class="table-dark">
                <tr>
                    <th>No</th>
                    <th>Nama Mitra</th>
                    <th>Gambar</th>
                    <th>Latitude</th>
                    <th>Longitude</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($mitras as $mitra)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $mitra->name }}</td>
                    <td>
                        @if ($mitra->image)
                        <img src="{{ asset('storage/' . $mitra->image) }}" alt="Foto Mitra" width="70">
                        @else
                            <span class="text-muted">No Image</span>
                        @endif
                    </td>
                    <td>{{ $mitra->latitude }}</td>
                    <td>{{ $mitra->longitude }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-muted">Belum ada data mitra.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
