<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="{{ url('/') }}" class="brand-link"> 
        <img src="{{ asset(auth()->user()->photo) }}" alt="KongsiTrack Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light">KongsiTrack</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">

                {{-- Dashboard --}}
                <li class="nav-item">
                    <a href="{{ route('dashboard.index') }}" class="nav-link {{ request()->routeIs('dashboard.*') ? 'active' : '' }}">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>Dashboard</p> 
                    </a>
                </li>

                @auth
                    {{-- Role: Admin --}}
                    @if (auth()->user()->akses === 'admin')
                        <li class="nav-item">
                            <a href="{{ route('admin.analitik') }}" class="nav-link {{ request()->routeIs('admin.analitik') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-chart-bar"></i>
                                <p>Analitik</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('produks.index') }}" class="nav-link {{ request()->routeIs('produks.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-box"></i>
                                <p>Produk</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('users.index') }}" class="nav-link {{ request()->routeIs('users.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-box"></i>
                                <p>Manajemen User</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('mitras.index') }}" class="nav-link {{ request()->routeIs('mitras.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-users"></i>
                                <p>Mitra</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('stok-mitra.index') }}" class="nav-link {{ request()->routeIs('stok-mitras.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-users"></i>
                                <p>Stok-Mitra</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('stoks.index') }}" class="nav-link {{ request()->routeIs('stoks.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-warehouse"></i>
                                <p>Semua Stok</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('stok-pusat.index') }}" class="nav-link {{ request()->routeIs('stok-pusat.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-warehouse"></i>
                                <p>Stok Pusat</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('pengiriman-stok.index') }}" class="nav-link {{ request()->routeIs('pengiriman-stok.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-shipping-fast"></i>
                                <p>Pengiriman</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('profile.index') }}" class="nav-link {{ request()->routeIs('profile.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-check-circle"></i>
                                <p>My Profile</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('keuangan.index') }}" class="nav-link {{ request()->routeIs('keuangan.index*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-check-circle"></i>
                                <p>Keuangan</p>
                            </a>
                        </li>

                    {{-- Role: Sales --}}
                    @elseif (auth()->user()->akses === 'sales')
                        <li class="nav-item">
                            <a href="{{ route('pengiriman-stok.index') }}" class="nav-link {{ request()->routeIs('pengiriman-stok.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-check-circle"></i>
                                <p>Konfirmasi Pengiriman</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('mitra.sales') }}" class="nav-link {{ request()->routeIs('mitra-sales.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-check-circle"></i>
                                <p>Mitra Anda</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('profile.index') }}" class="nav-link {{ request()->routeIs('profile.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-check-circle"></i>
                                <p>My Profile</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('stok.mitra.index') }}" class="nav-link {{ request()->routeIs('stok.mitra.index.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-check-circle"></i>
                                <p>Stok Permitra</p>
                            </a>
                    @endif
                @endauth

            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
