@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h1 class="mb-4">Ringkasan Keuangan</h1>

    {{-- Ringkasan per mitra --}}
    <h4>Total Pengiriman Per Mitra</h4>
    <div class="table-responsive mb-4">
        <table class="table table-bordered table-striped table-hover">
            <thead class="table-dark">
                <tr>
                    <th>No</th>
                    <th>Mitra</th>
                    <th>Total Masuk</th>
                    <th>Total Harga</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($totalPerMitra as $index => $mitra)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $mitra->mitra_name }}</td>
                    <td>{{ $mitra->total_masuk }}</td>
                    <td>Rp {{ number_format($mitra->total_harga, 0, ',', '.') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    {{-- Total keseluruhan --}}
    <h4 class="mb-4">
        Total Keseluruhan Pengiriman: 
        <span class="text-primary">Rp {{ number_format($totalKeseluruhan, 0, ',', '.') }}</span>
    </h4>

    {{-- Detail stok --}}
    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover align-middle">
            <thead class="table-secondary">
                <tr>
                    <th>No</th>
                    <th>Tanggal</th>
                    <th>Produk</th>
                    <th>Mitra</th>
                    <th>Masuk</th>
                    <th>Terjual</th>
                    <th>Sisa</th>
                    <th>Harga Satuan</th>
                    <th>Total Harga</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($stoks as $stok)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $stok->date }}</td>
                    <td>{{ $stok->produk->name ?? '-' }}</td>
                    <td>{{ $stok->mitra->name ?? '-' }}</td>
                    <td>{{ $stok->masuk }}</td>
                    <td>{{ $stok->terjual }}</td>
                    <td>{{ $stok->sisa }}</td>
                    <td>Rp {{ number_format($stok->harga_satuan, 0, ',', '.') }}</td>
                    <td>Rp {{ number_format($stok->total_harga, 0, ',', '.') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    {{ $stoks->links() }}
</div>
@endsection
