@extends('layouts.app')

@push('styles')
<style>
    .fa-square {
        font-size: 1.2rem;
    }
</style>
@endpush

@section('content')
<div class="container-fluid py-4">

    {{-- TAMPILAN ADMIN --}}
    @if(auth()->user()->akses === 'admin')
        <div class="row">
            <div class="col-lg-4 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>{{ $totalProduk }}</h3>
                        <p>Total Produk</p>
                    </div>
                    <div class="icon"><i class="fas fa-boxes"></i></div>
                </div>
            </div>
            <div class="col-lg-4 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>{{ $totalMitra }}</h3>
                        <p>Total Mitra</p>
                    </div>
                    <div class="icon"><i class="fas fa-users"></i></div>
                </div>
            </div>
            <div class="col-lg-4 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>{{ $totalStok }}</h3>
                        <p>Total Stok Tersedia</p>
                    </div>
                    <div class="icon"><i class="fas fa-warehouse"></i></div>
                </div>
            </div>
        </div>

        {{-- Ringkasan Stok Menipis --}}
        @if($stokMenipis->count())
            <div class="alert alert-danger">
                <h5>Produk dengan stok menipis:</h5>
                <ul class="mb-0">
                    @foreach($stokMenipis as $item)
                        <li>Nama :
                            <strong>
                                {{ $item->mitra->name }}
                            </strong> - Produk :
                            <strong>
                                {{ $item->produk->name }}
                            </strong> -  
                            
                            Tersedia: {{ $item->sisa }} / Minimum: {{ $item->produk->minimum_stok }}
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Filter Tahun --}}
        <form method="GET" class="mb-3">
            <div class="row">
                <div class="col-md-4">
                    <label for="tahun">Pilih Tahun:</label>
                    <select name="tahun" id="tahun" class="form-control" onchange="this.form.submit()">
                        <option value="">Semua Tahun</option>
                        @foreach ($daftarTahun as $tahun)
                            <option value="{{ $tahun }}" {{ $tahun == $tahunDipilih ? 'selected' : '' }}>
                                {{ $tahun }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </form>

        {{-- Grafik Penjualan --}}
        <div class="card mt-4">
            <div class="card-header">
                <h3 class="card-title">Grafik Penjualan Bulanan</h3>
            </div>
            <div class="card-body">
                <canvas id="penjualanChart" height="100"></canvas>
                <div class="mt-3 d-flex flex-wrap align-items-center">
                    <span class="me-3"><i class="fas fa-square text-danger me-1"></i> Rendah</span>
                    <span class="me-3"><i class="fas fa-square text-warning me-1"></i> Sedang</span>
                    <span class="me-3"><i class="fas fa-square text-primary me-1"></i> Tinggi</span>
                </div>
            </div>
        </div>

    {{-- TAMPILAN SALES --}}
    @elseif(auth()->user()->akses === 'sales')
        {{-- Ringkasan Total Mitra --}}
        <div class="row mb-4">
            <div class="col-lg-4 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>{{ $totalMitraSales }}</h3>
                        <p>Total Mitra Anda</p>
                    </div>
                    <div class="icon"><i class="fas fa-handshake"></i></div>
                </div>
            </div>
        </div>

        {{-- Stok Menipis --}}
        @if($stokMenipisSales->count())
            <div class="alert alert-danger">
                <h5>Stok Menipis pada Mitra Anda:</h5>
                <ul class="mb-0">
                    @foreach($stokMenipisSales as $item)
                        <li>
                            Produk :
                            <strong>
                                {{ $item->produk->name }}
                            </strong> - 
                            Mitra : {{ $item->mitra->name }} - 
                            Tersedia : {{ $item->sisa }} / Minimum: {{ $item->produk->minimum_stok }}
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Grafik Penjualan per Mitra --}}
        <div class="card mt-4">
            <div class="card-header">
                <h3 class="card-title">Grafik Penjualan per Mitra</h3>
            </div>
            <div class="card-body">
                <canvas id="penjualanMitraChart" height="100"></canvas>
                <div class="mt-3 d-flex flex-wrap align-items-center">
                    <span class="me-3"><i class="fas fa-square text-danger me-1"></i> Rendah</span>
                    <span class="me-3"><i class="fas fa-square text-warning me-1"></i> Sedang</span>
                    <span class="me-3"><i class="fas fa-square text-primary me-1"></i> Tinggi</span>
                </div>
            </div>
        </div>

        {{-- Tombol menuju pengiriman --}}
        <div class="card mt-4">
            <div class="card-body">
                <p>Silakan buka halaman berikut untuk melihat pengiriman:</p>
                <a href="{{ route('pengiriman-stok.index') }}" class="btn btn-primary">
                    <i class="fas fa-truck"></i> Lihat Pengiriman Masuk
                </a>
            </div>
        </div>
    @endif

</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

@if(auth()->user()->akses === 'admin')
<script>
    const dataTerjual = {!! json_encode($dataTerjual) !!};
    const max = Math.max(...dataTerjual);
    const min = Math.min(...dataTerjual);

    function getColor(value) {
        if (max === min) return 'rgba(100, 149, 237, 0.6)';
        const ratio = (value - min) / (max - min);
        if (ratio < 0.33) return 'rgba(255, 99, 132, 0.7)';
        if (ratio < 0.66) return 'rgba(255, 206, 86, 0.7)';
        return 'rgba(75, 192, 192, 0.7)';
    }

    const backgroundColors = dataTerjual.map(getColor);

    const ctx = document.getElementById('penjualanChart').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: {!! json_encode($labelBulan) !!},
            datasets: [{
                label: 'Jumlah Terjual',
                data: dataTerjual,
                backgroundColor: backgroundColors,
                borderColor: backgroundColors,
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { display: false },
                title: {
                    display: true,
                    text: {!! json_encode('Penjualan per Bulan' . ($tahunDipilih ? " ($tahunDipilih)" : " (Semua Tahun)")) !!}
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: { precision: 0 }
                }
            }
        }
    });
</script>
@endif

@if(auth()->user()->akses === 'sales')
<script>
    const dataPenjualanMitra = {!! json_encode($dataTerjualSales) !!};
    const labelMitra = {!! json_encode($labelMitraSales) !!};

    if (dataPenjualanMitra.length && labelMitra.length) {
        const maxSales = Math.max(...dataPenjualanMitra);
        const minSales = Math.min(...dataPenjualanMitra);

        function getBarColor(value) {
            if (maxSales === minSales) return 'rgba(100, 149, 237, 0.6)';
            const ratio = (value - minSales) / (maxSales - minSales);
            if (ratio < 0.33) return 'rgba(255, 99, 132, 0.7)';
            if (ratio < 0.66) return 'rgba(255, 206, 86, 0.7)';
            return 'rgba(75, 192, 192, 0.7)';
        }

        const warnaBackground = dataPenjualanMitra.map(getBarColor);

        const ctxMitra = document.getElementById('penjualanMitraChart').getContext('2d');
        new Chart(ctxMitra, {
            type: 'bar',
            data: {
                labels: labelMitra,
                datasets: [{
                    label: 'Jumlah Terjual',
                    data: dataPenjualanMitra,
                    backgroundColor: warnaBackground,
                    borderColor: warnaBackground,
                    borderWidth: 1,
                    borderRadius: 5
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { display: false },
                    title: {
                        display: true,
                        text: 'Penjualan per Mitra'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: { precision: 0 }
                    }
                },
                animation: {
                    duration: 1000,
                    easing: 'easeOutQuart'
                }
            }
        });
    }
</script>
@endif
@endpush
