@include('layouts.authup')

<body class="hold-transition login-page">
  <div class="login-box">
    <div class="login-logo mb-2">
      <b>KonsiTrack</b> Inventory
    </div>

    <div class="card card-outline card-primary">
      <div class="card-header text-center">
        <h3 class="card-title">Reset Password</h3>
      </div>
      <div class="card-body">

        @if(session('error'))
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">&times;</button>
          </div>
        @endif

        @if(session('success'))
          <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            {{ session('success') }}
          </div>
        @endif

        <form action="{{ route('password.update') }}" method="POST">
          @csrf
          <input type="hidden" name="token" value="{{ $token }}">

          {{-- Email --}}
          <div class="input-group mb-3">
            <input type="email" name="email" class="form-control" placeholder="Email" required>
            <div class="input-group-append">
              <div class="input-group-text"><span class="fas fa-envelope"></span></div>
            </div>
          </div>

          {{-- Password --}}
          <div class="input-group mb-3">
            <input type="password" name="password" class="form-control" placeholder="Password Baru" required>
            <div class="input-group-append">
              <div class="input-group-text"><span class="fas fa-lock"></span></div>
            </div>
          </div>

          {{-- Konfirmasi --}}
          <div class="input-group mb-3">
            <input type="password" name="password_confirmation" class="form-control" placeholder="Konfirmasi Password" required>
            <div class="input-group-append">
              <div class="input-group-text"><span class="fas fa-lock"></span></div>
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-12">
              <button type="submit" class="btn btn-primary btn-block">Reset Password</button>
            </div>
          </div>
        </form>

        <p class="mb-1">
          <a href="{{ url('/login') }}">Kembali ke login</a>
        </p>
      </div>
    </div>
  </div>

@include('layouts.authdwon')
