@include('layouts.authup')

<body class="hold-transition login-page">
  <div class="login-box">
    <div class="login-logo mb-2">
      <b>KonsiTrack</b> Inventory
    </div>

    <div class="card card-outline card-primary">
      <div class="card-header text-center">
        <h3 class="card-title">Lupa Password</h3>
      </div>
      <div class="card-body">

        {{-- Alert error --}}
      {{-- @if($errors->any())
      <div class="alert alert-danger alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <ul class="mb-0">
          @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
          @endforeach
        </ul>
      </div>
    @endif --}}

        {{-- Flash error --}}
        @if(session('error'))
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">&times;</button>
          </div>
        @endif

        @if(session('success'))
          <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            {{ session('success') }}
          </div>
        @endif
      


        <form action="{{ route('password.email') }}" method="POST">
          @csrf

          {{-- Email --}}
          <div class="input-group mb-3">
            <input type="email" name="email" value="{{ old('email') }}"
                   class="form-control @error('email') is-invalid @enderror"
                   placeholder="Email" required autofocus>
            <div class="input-group-append">
              <div class="input-group-text"><span class="fas fa-envelope"></span></div>
            </div>
            @error('email')
              <div class="invalid-feedback d-block">{{ $message }}</div>
            @enderror
          </div>

          {{-- Submit --}}
          <div class="row mb-3">
            <div class="col-12">
              <button type="submit" class="btn btn-primary btn-block">Kirim Link Reset Password</button>
            </div>
          </div>
        </form>

        <p class="mb-1">
          <a href="{{ url('/login') }}">Kembali ke halaman login</a>
        </p>

      </div>
    </div>
  </div>

@include('layouts.authdwon')
