<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class StokSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        foreach (range(1, 10) as $index) {
            DB::table('stoks')->insert([
                'produk_id' => $faker->numberBetween(1, 10),
                'mitra_id' => $faker->numberBetween(1, 10),
                'date' => $faker->date(),
                'masuk' => $faker->numberBetween(1, 100),
                'terjual' => $faker->numberBetween(1, 50),
                'return' => $faker->numberBetween(0, 10),
                'sisa' => $faker->randomFloat(2, 0, 100),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
