<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class ProdukSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        // Membuat 10 produk contoh
        foreach (range(1, 10) as $index) {
            DB::table('produks')->insert([
                'name' => $faker->word(),
                'explanation' => $faker->sentence(),
                'image' => $faker->imageUrl(),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
