<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('stoks', function (Blueprint $table) {
            $table->dropForeign(['mitra_id']); // hapus FK dulu
            $table->unsignedBigInteger('mitra_id')->nullable()->change(); // ubah jadi nullable
            $table->foreign('mitra_id')->references('id')->on('mitras')->onDelete('cascade'); // pasang FK lagi
        });
    }

    public function down(): void
    {
        Schema::table('stoks', function (Blueprint $table) {
            $table->dropForeign(['mitra_id']);
            $table->unsignedBigInteger('mitra_id')->nullable(false)->change(); // balik ke NOT NULL
            $table->foreign('mitra_id')->references('id')->on('mitras')->onDelete('cascade');
        });
    }
};
