<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('pengiriman_stoks', function (Blueprint $table) {
        $table->id();
        $table->foreignId('produk_id')->constrained()->onDelete('cascade');
        $table->foreignId('mitra_id')->constrained()->onDelete('cascade');
        $table->integer('jumlah');
        $table->date('tanggal_kirim');
        $table->date('tanggal_terima')->nullable();
        $table->enum('status', ['dikirim', 'diterima'])->default('dikirim');
        $table->text('catatan')->nullable();
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pengiriman_stoks');
    }
};
