<?php

namespace App\Observers;

use App\Models\Stok;

class StokObserver
{
    /**
     * Handle the Stok "created" event.
     */
    public function saving(Stok $stok)
    {
        // Nilai default jika null
    $stok->harga_satuan = $stok->harga_satuan ?? 0;
    $stok->terjual      = $stok->terjual ?? 0;
    $stok->return       = $stok->return ?? 0;

    // Pastikan return tidak melebihi terjual
    $return = min($stok->return, $stok->terjual);

    // Hitung total_harga = (terjual - return) * harga_satuan
    $stok->total_harga = ($stok->terjual - $return) * $stok->harga_satuan;
    }

    /**
     * Handle the Stok "updated" event.
     */
    public function updated(Stok $stok): void
    {
        //
    }

    /**
     * Handle the Stok "deleted" event.
     */
    public function deleted(Stok $stok): void
    {
        //
    }

    /**
     * Handle the Stok "restored" event.
     */
    public function restored(Stok $stok): void
    {
        //
    }

    /**
     * Handle the Stok "force deleted" event.
     */
    public function forceDeleted(Stok $stok): void
    {
        //
    }
}
