<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'username',
        'email',
        'password',
        'akses',
        'photo',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

//     public function penanggungJawab()
// {
//     return $this->hasOne(\App\Models\PenanggungJawab::class);
// }

// public function role()
// {
//     return $this->penanggungJawab?->role ?? 'guest';
// }

       // Cek role
       public function isAdmin()
       {
           return $this->akses === 'admin';
       }
       
       public function isSales()
       {
           return $this->akses === 'sales';
       }

    public function mitras()
    {
        return $this->hasMany(Mitra::class);
    }

  
}

