<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Produk extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'explanation', 'price', 'image'];
    public function stoks()
    {
        return $this->hasMany(Stok::class);
    }

    public function stokPusat()
{
    return $this->hasOne(StokPusat::class);
}

    public function pengirimanStoks()
    {
        return $this->hasMany(PengirimanStok::class);
    }

}
