<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PengirimanStok extends Model
{
    protected $fillable = [
        'produk_id', 'user_id','mitra_id', 'jumlah', 'status', 'tanggal_kirim', 'tanggal_terima',  'total_harga', 'harga_satuan','price',
    ];

    public function produk()
    {
        return $this->belongsTo(Produk::class, 'produk_id');
    }
    
    public function mitra()
    {
        return $this->belongsTo(Mitra::class, 'mitra_id');
    }
    
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    
    public function sales()
    {
        return $this->belongsTo(User::class, 'sales_id');
    }
    
}