<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Mitra extends Model
{
    use HasFactory;

    // Nama tabel yang digunakan
    protected $table = 'mitras';

    // Kolom yang boleh diisi (Mass Assignment)
    protected $fillable = [
        'name', 'image', 'latitude', 'longitude', 'user_id'
    ];
    

    // Kolom yang tidak boleh diisi (optional)
    protected $guarded = [];

    public function pengirimanStoks()
    {
        return $this->hasMany(PengirimanStok::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function stoks()
{
    return $this->hasMany(Stok::class);
}


}
