<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SalesMiddleware
{
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->check() && auth()->user()->akses === 'sales') {
            return $next($request);
        } 

        abort(403, 'Akses hanya untuk Sales');
    }
}
