<?php

namespace App\Http\Controllers;

use App\Models\Stok;
use App\Models\Produk;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class StokPusatController extends Controller
{
    public function index()
    {
        $stoks = Stok::with('produk')
            ->whereNull('mitra_id')
            ->orderBy('date', 'desc')
            ->get();

        return view('stok_pusat.index', compact('stoks'));
    }

    public function create()
    {
        $produks = Produk::all();
        return view('stok_pusat.create', compact('produks'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'produk_id' => 'required|exists:produks,id',
            'masuk'     => 'required|numeric|min:1',
        ]);

        $stok = Stok::firstOrCreate(
            [
                'produk_id' => $request->produk_id,
                'mitra_id' => null,
            ],
            [
                'sisa' => 0,
                'date' => now(),
            ]
        );

        $stok->masuk += $request->masuk;
        $stok->sisa += $request->masuk;
        $stok->date = now();
        $stok->save();

        return redirect()->route('stok-pusat.index')->with('success', 'Stok pusat berhasil ditambahkan.');
    }
}
