<?php

namespace App\Http\Controllers;

use App\Models\Stok;
use App\Models\Mitra;
use App\Models\Produk;
use Illuminate\Http\Request;
use App\Models\PengirimanStok;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class StokMitraController extends Controller
{
    public function index()
{
    $stoks = \DB::table('stoks')
        ->join('produks', 'stoks.produk_id', '=', 'produks.id')
        ->join('mitras', 'stoks.mitra_id', '=', 'mitras.id')
        ->whereNotNull('stoks.mitra_id')
        ->select(
            'stoks.produk_id',
            'stoks.mitra_id',
            'produks.name as produk_nama',
            'mitras.name as mitra_nama',
            \DB::raw('SUM(stoks.masuk) as total_masuk'),
            \DB::raw('SUM(stoks.terjual) as total_terjual'),
            \DB::raw('SUM(stoks.return) as total_return'),
            \DB::raw('SUM(stoks.sisa) as total_sisa')
        )
        ->groupBy('stoks.produk_id', 'stoks.mitra_id', 'produks.name', 'mitras.name')
        ->orderBy('produks.name')
        ->get();

    return view('stok_mitra.index', compact('stoks'));
}


    public function create()
    {
        $produks = Produk::all();
        $mitras = Mitra::all();
        return view('stok_mitra.create', compact('produks', 'mitras'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'produk_id' => 'required|exists:produks,id',
            'mitra_id' => 'required|exists:mitras,id',
            'masuk'     => 'required|numeric|min:1',
        ]);

        $stok = Stok::firstOrCreate(
            [
                'produk_id' => $request->produk_id,
                'mitra_id' => $request->mitra_id,
            ],
            [
                'sisa' => 0,
                'date' => now(),
            ]
        );

        $stok->masuk += $request->masuk;
        $stok->sisa += $request->masuk;
        $stok->date = now();
        $stok->save();

        return redirect()->route('stok-mitra.index')->with('success', 'Stok mitra berhasil ditambahkan.');
    }

    public function riwayat()
{
    $user = auth()->user();

    if ($user->akses === 'sales') {
        // Ambil semua mitra milik sales
        $mitras = Mitra::where('user_id', $user->id)->get();

        // Ambil semua pengiriman yang berkaitan dengan mitra tersebut
        $pengiriman = PengirimanStok::with(['mitra', 'produk'])
            ->whereIn('mitra_id', $mitras->pluck('id'))
            ->latest()
            ->get();
    } else {
        // Admin bisa lihat semua
        $pengiriman = PengirimanStok::with(['mitra', 'produk'])->latest()->get();
    }

    return view('riwayat-stok.index', compact('pengiriman'));
}


    public function terima($id)
    {
        $pengiriman = PengirimanStok::findOrFail($id);

        if ($pengiriman->status === 'diterima') {
            return back()->with('error', 'Pengiriman sudah diterima.');
        }

        // Tambahkan stok ke mitra
        $stokMitra = Stok::firstOrCreate(
            [
                'produk_id' => $pengiriman->produk_id,
                'mitra_id' => $pengiriman->mitra_id,
            ],
            [
                'date' => now(),
            ]
        );

        $stokMitra->masuk += $pengiriman->jumlah;
        $stokMitra->sisa += $pengiriman->jumlah;
        $stokMitra->save();

        // Update status pengiriman
        $pengiriman->status = 'diterima';
        $pengiriman->tanggal_terima = now();
        $pengiriman->save();

        return redirect()->route('riwayat-stok.index')->with('success', 'Pengiriman diterima.');
    }

}
