<?php

namespace App\Http\Controllers;

use App\Models\Stok;
use App\Models\Mitra;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class SalesStokController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        if ($user->akses !== 'sales') {
            abort(403, 'Akses ditolak');
        }

        $stoks = \DB::table('stoks')
        ->join('produks', 'stoks.produk_id', '=', 'produks.id')
        ->join('mitras', 'stoks.mitra_id', '=', 'mitras.id')
        ->whereNotNull('stoks.mitra_id')
        ->select(
            'stoks.produk_id',
            'stoks.mitra_id',
            'produks.name as produk_nama',
            'mitras.name as mitra_nama',
            \DB::raw('SUM(stoks.masuk) as total_masuk'),
            \DB::raw('SUM(stoks.terjual) as total_terjual'),
            \DB::raw('SUM(stoks.return) as total_return'),
            \DB::raw('SUM(stoks.sisa) as total_sisa')
        )
        ->groupBy('stoks.produk_id', 'stoks.mitra_id', 'produks.name', 'mitras.name')
        ->orderBy('produks.name')
        ->get();

    return view('stok_mitra.index', compact('stoks'));
}
}