<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Mitra;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Storage;

class MitraController extends Controller
{
    public function index()
    {
        
       /** @var \App\Models\User $user */
        $user = auth()->user();

        if ($user->isAdmin()) {
            $mitras = Mitra::all();
        } elseif ($user->isSales()) {
            $mitras = $user->mitras;
        } else {
            $mitras = collect();
        }
        return view('mitras.index', compact('mitras'));
    }
    

    public function create()
    {
        $sales = User::where('akses', 'sales')->get();
        return view('mitras.create', compact('sales'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',
            'user_id' => 'required|exists:users,id',
        ]);

        $data = $request->only('name', 'latitude', 'longitude', 'user_id');

        if ($request->hasFile('image')) {
            $path = $request->file('image')->store('mitras', 'public');
            $data['image'] = $path; // simpan path tanpa "storage/"
        }

        Mitra::create($data);

        return redirect()->route('mitras.index')->with('success', 'Mitra berhasil ditambahkan!');
    }
        

    public function show(Mitra $mitra)
    {
        return view('mitras.show', compact('mitra'));
    }

    public function edit(Mitra $mitra)
    {
        $sales = User::where('akses', 'sales')->get();
        return view('mitras.edit', compact('mitra', 'sales'));
    }

    public function update(Request $request, $id)
    {
        $mitra = Mitra::findOrFail($id);

        $data = $request->validate([
            'name' => 'required|string|max:255',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'latitude' => 'nullable|numeric',
            'longitude' => 'nullable|numeric',
            'user_id' => 'required|exists:users,id',
        ]);

        if ($request->hasFile('image')) {
            // Hapus file lama jika ada
            if ($mitra->image && Storage::disk('public')->exists($mitra->image)) {
                Storage::disk('public')->delete($mitra->image);
            }

            $path = $request->file('image')->store('mitras', 'public');
            $data['image'] = $path;
        }

        $mitra->update($data);

        return redirect()->route('mitras.index')->with('success', 'Mitra berhasil diperbarui.');
    }


    public function destroy($id)
    {
        $mitra = Mitra::findOrFail($id);

        if ($mitra->image && file_exists(public_path($mitra->image))) {
            unlink(public_path($mitra->image));
        }

        $mitra->delete();

        return redirect()->route('mitras.index')->with('success', 'Mitra berhasil dihapus!');
    }

    public function salesMitra()
{
    $user = auth()->user();

    if ($user->akses !== 'sales') {
        abort(403, 'Tidak diizinkan.');
    }

    $mitras = \App\Models\Mitra::where('user_id', $user->id)->get();

    return view('mitras.sales', compact('mitras'));
}

}
