<?php

namespace App\Http\Controllers;

use App\Models\Stok;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class KeuanganController extends Controller
{
    public function index()
    {
        // Ambil data stok dengan relasi produk dan mitra (diurutkan berdasarkan updated_at agar data terbaru muncul)
        $stoks = Stok::with(['produk', 'mitra'])
            ->orderBy('updated_at', 'desc')
            ->paginate(15);

        // Hitung total per mitra (misalnya total jumlah yang masuk dan total_harga)
        $totalPerMitra = Stok::with('mitra:id,name')
            ->select('mitra_id', DB::raw('SUM(masuk) as total_masuk'), DB::raw('SUM(total_harga) as total_harga'))
            ->groupBy('mitra_id')
            ->get()
            ->map(function ($item) {
                return (object)[
                    'mitra_id'    => $item->mitra_id,
                    'mitra_name'  => $item->mitra->name ?? '-',
                    'total_masuk' => $item->total_masuk ?? 0,
                    'total_harga' => $item->total_harga ?? 0,
                ];
            });

        // Total keseluruhan dari semua stok (misalnya total_harga)
        $totalKeseluruhan = Stok::sum('total_harga');

        return view('keuangan.index', compact('stoks', 'totalPerMitra', 'totalKeseluruhan'));
    }
}
