<?php

namespace App\Http\Controllers;

use App\Models\Stok;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class AnalitikController extends Controller
{
    public function index()
{
    // Ambil total penjualan (terjual) dari tabel stoks, dikelompokkan per mitra
    $penjualan = Stok::select('mitras.id', 'mitras.name', 'mitras.latitude', 'mitras.longitude', DB::raw('SUM(terjual) as total'))
        ->join('mitras', 'stoks.mitra_id', '=', 'mitras.id')
        ->groupBy('mitras.id', 'mitras.name', 'mitras.latitude', 'mitras.longitude')
        ->get()
        ->map(function ($item) {
            return [
                'mitra' => [
                    'id' => $item->id,
                    'name' => $item->name,
                    'latitude' => $item->latitude,
                    'longitude' => $item->longitude,
                ],
                'total' => $item->total ?? 0,
            ];
        });

    return view('admin.analitik', compact('penjualan'));
}


}
